/////////////////////////////////////////////////////////////////
//
//	LZElzedAPI.h
//
//	Part of the LZ Kernel
//
//	Copyright (c) 2000-2010 by R R Le Cropane
//	All Rights Reserved
//
/////////////////////////////////////////////////////////////////

#ifndef __LZElzedAPI__
#define __LZElzedAPI__

#include "LZElzedPublic.h"

/////////////////////////////////////////////////////////////////
//  All Versions
/////////////////////////////////////////////////////////////////

ELZED_API char* ELZED_CALL_TYPE
	lzAnnotateExp( const char* szExpression );

ELZED_API char* ELZED_CALL_TYPE
	lzAnnotateParsedExp( LZObjectHandle hTheExpression );

ELZED_API char* ELZED_CALL_TYPE
	lzCheckExp( const char* szExpression );

ELZED_API bool ELZED_CALL_TYPE
	lzClearContext( void );

ELZED_API bool ELZED_CALL_TYPE
	lzClearErrorCallback( void );

ELZED_API void ELZED_CALL_TYPE
	lzClearLastError( void );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateBoolArray(	char cScope,
						const char* szVariableName,
						long lDimensions,
						long lDim1,
						long lDim2,
						long lDim3,
						long lDim4,
						long lDim5,
						long lDim6 );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateBoolVar(	char cScope,
						const char* szVariableName,
						bool bVariableValue );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateComplexArray(	char cScope,
							const char* szVariableName,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateComplexVar(	char cScope,
						const char* szVariableName,
						double dRealPart,
						double dImagPart );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateNumArray(	char cScope,
						const char* szVariableName,
						long lDimensions,
						long lDim1,
						long lDim2,
						long lDim3,
						long lDim4,
						long lDim5,
						long lDim6 );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateNumVar(	char cScope,
					const char* szVariableName,
					double dVariableValue );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreatePrivateContext( const char* szContextName );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreatePublicContext( const char* szContextName );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateStrArray(	char cScope,
						const char* szVariableName,
						long lStringSize,
						long lDimensions,
						long lDim1,
						long lDim2,
						long lDim3,
						long lDim4,
						long lDim5,
						long lDim6 );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzCreateStrVar(	char cScope,
					const char* szVariableName,
					long lStringSize,
					const char* szVariableValue );

ELZED_API bool ELZED_CALL_TYPE
	lzDefineError( char cScope, long lErrorID, const char* szErrorText );

ELZED_API long ELZED_CALL_TYPE
	lzDefineExpOp(	char cScope,
					const char* szOperatorName,
					const char* szOperatorType,
					const char* szReturnType,
					const char* szParmList,
					const char* szPrecedenceOp,
					const char* szExpression );

ELZED_API long ELZED_CALL_TYPE
	lzDefineExpOpStr(	char cScope,
						const char* szOperatorName,
						const char* szExpression );

ELZED_API void ELZED_CALL_TYPE
	lzDeleteExp( LZObjectHandle hTheExpression );

ELZED_API long ELZED_CALL_TYPE
	lzDeleteOp( char cScope, const char* szOperatorName );

ELZED_API long ELZED_CALL_TYPE
	lzDeleteVar( char cScope, const char* szVariableName );

ELZED_API bool ELZED_CALL_TYPE
	lzDestroyPrivateContext( const char* szContextName );

ELZED_API bool ELZED_CALL_TYPE
	lzDestroyPublicContext( const char* szContextName );

ELZED_API char ELZED_CALL_TYPE
	lzEvalExpHndl( LZObjectHandle hTheExpression );

ELZED_API bool ELZED_CALL_TYPE
	lzEvalExpHndlToBool( LZObjectHandle hTheExpression );

ELZED_API double ELZED_CALL_TYPE
	lzEvalExpHndlToComp( LZObjectHandle hTheExpression, double* dpImagPart );

ELZED_API double ELZED_CALL_TYPE
	lzEvalExpHndlToNum( LZObjectHandle hTheExpression );

ELZED_API char* ELZED_CALL_TYPE
	lzEvalExpHndlToStr( LZObjectHandle hTheExpression );

ELZED_API char ELZED_CALL_TYPE
	lzEvalExpStr( const char* szExpression );

ELZED_API bool ELZED_CALL_TYPE
	lzEvalExpStrToBool( const char* szExpression );

ELZED_API double ELZED_CALL_TYPE
	lzEvalExpStrToComp( const char* szExpression, double* dpImagPart );

ELZED_API double ELZED_CALL_TYPE
	lzEvalExpStrToNum( const char* szExpression );

ELZED_API char* ELZED_CALL_TYPE
	lzEvalExpStrToStr( const char* szExpression );

ELZED_API bool ELZED_CALL_TYPE
	lzGetAllowComplexResults( void );

ELZED_API bool ELZED_CALL_TYPE
	lzGetAllowImpliedMult( void );

ELZED_API char ELZED_CALL_TYPE
	lzGetAngleUnit( void );

ELZED_API bool ELZED_CALL_TYPE
	lzGetBoolArrayElement(	char cScope,
							const char* szVariableName,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzGetBoolArrayElementByHandle(	LZObjectHandle hTheHandle,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API char ELZED_CALL_TYPE
	lzGetBooleanTrue( void );

ELZED_API bool ELZED_CALL_TYPE
	lzGetBoolParm( LZObjectHandle hExOpUID, long lParmIndex );

ELZED_API bool ELZED_CALL_TYPE
	lzGetBoolVarValue( char cScope, const char* szVariableName );

ELZED_API bool ELZED_CALL_TYPE
	lzGetBoolVarValueByHandle( LZObjectHandle hTheHandle );

ELZED_API bool ELZED_CALL_TYPE
	lzGetComplexArrayElement(	char cScope,
								const char* szVariableName,
								double* dpRealValue,
								double* dpImagValue,
								long lDimensions,
								long lDim1,
								long lDim2,
								long lDim3,
								long lDim4,
								long lDim5,
								long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzGetComplexArrayElementByHandle(	LZObjectHandle hTheHandle,
										double* dpRealValue,
										double* dpImagValue,
										long lDimensions,
										long lDim1,
										long lDim2,
										long lDim3,
										long lDim4,
										long lDim5,
										long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzGetComplexVarValue(	char cScope,
							const char* szVariableName,
							double* dpRealPart,
							double* dpImagPart );

ELZED_API bool ELZED_CALL_TYPE
	lzGetComplexVarValueByHandle(	LZObjectHandle hTheHandle,
									double* dpRealPart,
									double* dpImagPart );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzGetContextHandle( const char* szContextName );

ELZED_API char* ELZED_CALL_TYPE
	lzGetContextName( LZObjectHandle hContextUID );

ELZED_API char ELZED_CALL_TYPE
	lzGetCoordinateFormat( void );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzGetCurrentContextHandle( void );

ELZED_API char* ELZED_CALL_TYPE
	lzGetCurrentContextName( void );

ELZED_API char ELZED_CALL_TYPE
	lzGetDefaultVariableScope( void );

ELZED_API unsigned long ELZED_CALL_TYPE
	lzGetElzedObjectCount( void );

ELZED_API char* ELZED_CALL_TYPE
	lzGetErrorText( long lErrorID );

ELZED_API bool ELZED_CALL_TYPE
	lzGetForceComplexResults( void );

ELZED_API int ELZED_CALL_TYPE
	lzGetFormattedResultPrecisionLimit( void );

ELZED_API double ELZED_CALL_TYPE
	lzGetImagParm( LZObjectHandle hExOpUID, long lParmIndex );

ELZED_API bool ELZED_CALL_TYPE
	lzGetInvertArrayIndices( void );

ELZED_API bool ELZED_CALL_TYPE
	lzGetLastBoolResult( void );

ELZED_API long ELZED_CALL_TYPE
	lzGetLastErrorID( void );

ELZED_API char* ELZED_CALL_TYPE
	lzGetLastErrorText( void );

ELZED_API double ELZED_CALL_TYPE
	lzGetLastImagResult( void );

ELZED_API double ELZED_CALL_TYPE
	lzGetLastNumResult( void );

ELZED_API long ELZED_CALL_TYPE
	lzGetLastParseIndex( void );

ELZED_API double ELZED_CALL_TYPE
	lzGetLastRealResult( void );

ELZED_API char ELZED_CALL_TYPE
	lzGetLastResultType( void );

ELZED_API char* ELZED_CALL_TYPE
	lzGetLastStrResult( void );

ELZED_API unsigned long ELZED_CALL_TYPE
	lzGetNextElzedObjectSerialNumber( void );

ELZED_API double ELZED_CALL_TYPE
	lzGetNumArrayElement(	char cScope,
							const char* szVariableName,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API double ELZED_CALL_TYPE
	lzGetNumArrayElementByHandle(	LZObjectHandle hTheHandle,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API double ELZED_CALL_TYPE
	lzGetNumParm( LZObjectHandle hExOpUID, long lParmIndex );

ELZED_API double ELZED_CALL_TYPE
	lzGetNumVarValue( char cScope, const char* szVariableName );

ELZED_API double ELZED_CALL_TYPE
	lzGetNumVarValueByHandle( LZObjectHandle hTheHandle );

ELZED_API char ELZED_CALL_TYPE
	lzGetOutputBase( void );

ELZED_API long ELZED_CALL_TYPE
	lzGetParmCount( LZObjectHandle hExOpUID );

ELZED_API char* ELZED_CALL_TYPE
	lzGetParmSig( LZObjectHandle hExOpUID );

ELZED_API char ELZED_CALL_TYPE
	lzGetParmType( LZObjectHandle hExOpUID, long lParmIndex );

ELZED_API char ELZED_CALL_TYPE
	lzGetQuoteMark( void );

ELZED_API char ELZED_CALL_TYPE
	lzGetRadixMark( void );

ELZED_API double ELZED_CALL_TYPE
	lzGetRealParm( LZObjectHandle hExOpUID, long lParmIndex );

ELZED_API char* ELZED_CALL_TYPE
	lzGetStrArrayElement(	char cScope,
							const char* szVariableName,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API char* ELZED_CALL_TYPE
	lzGetStrArrayElementByHandle(	LZObjectHandle hTheHandle,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API char* ELZED_CALL_TYPE
	lzGetStrParm( LZObjectHandle hExOpUID, long lParmIndex );

ELZED_API char* ELZED_CALL_TYPE
	lzGetStrVarValue( char cScope, const char* szVariableName );

ELZED_API char* ELZED_CALL_TYPE
	lzGetStrVarValueByHandle( LZObjectHandle hTheHandle );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzGetVarHandle( char cScope, const char* szVariableValue );

ELZED_API char ELZED_CALL_TYPE
	lzGetVarType( char cScope, const char* szVariableName );

ELZED_API char ELZED_CALL_TYPE
	lzGetVarTypeByHandle( LZObjectHandle mTheHandle );

ELZED_API bool ELZED_CALL_TYPE
	lzInitialize( const char* szRegKey );

ELZED_API bool ELZED_CALL_TYPE
	lzIsArray( char cScope, const char* szVariableName );

ELZED_API bool ELZED_CALL_TYPE
	lzIsArrayHandle( LZObjectHandle hTheHandle );

ELZED_API bool ELZED_CALL_TYPE
	lzIsOp(	char cScope, const char* szOperatorName );

ELZED_API bool ELZED_CALL_TYPE
	lzIsSymbol(	char cScope, const char* szSymbolName );

ELZED_API bool ELZED_CALL_TYPE
	lzIsVar( char cScope, const char* szVariableName );

ELZED_API bool ELZED_CALL_TYPE
	lzIsVarHandle( LZObjectHandle hTheHandle );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkBoolArray(	char cScope,
						const char* szVariableName,
						bool* bpVariable,
						long lDimensions,
						long lDim1,
						long lDim2,
						long lDim3,
						long lDim4,
						long lDim5,
						long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkBoolVar(	char cScope,
					const char* szVariableName,
					bool* bpVariable );

ELZED_API long ELZED_CALL_TYPE
	lzLinkCallbackOp(	char cScope,
						const char* szOperatorName,
						const char* szOperatorType,
						const char* szReturnType,
						const char* szParmList,
						const char* szPrecedenceOp,
						ExtOpFunction pOpFunction );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkComplexArray(	char cScope,
						const char* szVariableName,
						double* dpComplexArray,
						long lDimensions,
						long lDim1,
						long lDim2,
						long lDim3,
						long lDim4,
						long lDim5,
						long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkComplexVar(	char cScope,
						const char* szVariableName,
						double* dpComplexVariable );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkNumArray(	char cScope,
					const char* szVariableName,
					double* dpVariable,
					long lDimensions,
					long lDim1,
					long lDim2,
					long lDim3,
					long lDim4,
					long lDim5,
					long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkNumVar(	char cScope,
					const char* szVariableName,
					double* dpVariable );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkStrArray(	char cScope,
					const char* szVariableName,
					char* cpVariableValue,
					long lStringSize,
					long lDimensions,
					long lDim1,
					long lDim2,
					long lDim3,
					long lDim4,
					long lDim5,
					long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzLinkStrVar(	char cScope,
					const char* szVariableName,
					char* cpVariable,
					long lStringSize );

ELZED_API bool ELZED_CALL_TYPE
	lzLockContext( void );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzParseExp( const char* szExpression );

ELZED_API long ELZED_CALL_TYPE
	lzReadExpOp(	char cScope,
					const char* szOperatorName,
					const char* szOperatorType,
					const char* szReturnType,
					const char* szParmList,
					const char* szPrecedenceOp,
					const char* szFilePathName );

ELZED_API long ELZED_CALL_TYPE
	lzReadExpOpStr(	char cScope,
					const char* szOperatorName,
					const char* szFilePathName );

ELZED_API bool ELZED_CALL_TYPE
	lzRelease( void );

ELZED_API bool ELZED_CALL_TYPE
	lzReleaseContext( void );

ELZED_API bool ELZED_CALL_TYPE
	lzReset( void );

ELZED_API bool ELZED_CALL_TYPE
	lzResetDefaultContext( void );

ELZED_API char* ELZED_CALL_TYPE
	lzRevertParsedExp( LZObjectHandle hTheExpression );

ELZED_API void ELZED_CALL_TYPE
	lzSetAllowComplexResults( bool bAllowComplexResults );

ELZED_API void ELZED_CALL_TYPE
	lzSetAllowImpliedMult( bool bAllowImpliedMult );

ELZED_API void ELZED_CALL_TYPE
	lzSetAngleUnit( char cAngleUnitCode );

ELZED_API bool ELZED_CALL_TYPE
	lzSetBoolArrayElement(	char cScope,
							const char* szVariableName,
							bool bVariableValue,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzSetBoolArrayElementByHandle(	LZObjectHandle hTheHandle,
									bool bVariableValue,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API void ELZED_CALL_TYPE
	lzSetBooleanTrue( char cBooleanTrueCode );

ELZED_API long ELZED_CALL_TYPE
	lzSetBoolResult( LZObjectHandle hExOpUID, bool bTheResult );

ELZED_API bool ELZED_CALL_TYPE
	lzSetBoolVar(	char cScope,
					const char* szVariableName,
					bool bVariableValue );

ELZED_API bool ELZED_CALL_TYPE
	lzSetBoolVarByHandle(	LZObjectHandle hTheHandle,
							bool bVariableValue );

ELZED_API bool ELZED_CALL_TYPE
	lzSetComplexArrayElement(	char cScope,
								const char* szVariableName,
								double dRealValue,
								double dImagValue,
								long lDimensions,
								long lDim1,
								long lDim2,
								long lDim3,
								long lDim4,
								long lDim5,
								long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzSetComplexArrayElementByHandle(	LZObjectHandle hTheHandle,
										double dRealPart,
										double dImagPart,
										long lDimensions,
										long lDim1,
										long lDim2,
										long lDim3,
										long lDim4,
										long lDim5,
										long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzSetComplexVar(	char cScope,
						const char* szVariableName,
						double dRealPart,
						double dImagPart );

ELZED_API bool ELZED_CALL_TYPE
	lzSetComplexVarByHandle(	LZObjectHandle hTheHandle,
								double dRealPart,
								double dImagPart );

ELZED_API LZObjectHandle ELZED_CALL_TYPE
	lzSetContext( const char* szContextName, bool bLock = false );

ELZED_API void ELZED_CALL_TYPE
	lzSetCoordinateFormat( char cCoordinateFormatCode );

ELZED_API bool ELZED_CALL_TYPE
	lzSetDefaultContext( const char* szContextName );

ELZED_API void ELZED_CALL_TYPE
	lzSetDefaultVariableScope( char cDefaultVariableScopeCode );

ELZED_API bool ELZED_CALL_TYPE
	lzSetErrorCallback( ErrorFunction pErrorFunction );

ELZED_API void ELZED_CALL_TYPE
	lzSetForceComplexResults( bool bForceComplexResults );

ELZED_API void ELZED_CALL_TYPE
	lzSetFormattedResultPrecisionLimit( int iFormattedResultPrecisionLimit );

ELZED_API bool ELZED_CALL_TYPE
	lzSetImagArrayElement(	char cScope,
							const char* szVariableName,
							double dImagValue,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzSetImagArrayElementByHandle(	LZObjectHandle hTheHandle,
									double dImagPart,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API long ELZED_CALL_TYPE
	lzSetImagResult( LZObjectHandle hExOpUID, double dTheResult );

ELZED_API bool ELZED_CALL_TYPE
	lzSetImagVar(	char cScope,
					const char* szVariableName,
					double dImagPart );

ELZED_API bool ELZED_CALL_TYPE
	lzSetImagVarByHandle(	LZObjectHandle hTheHandle,
							double dImagPart );

ELZED_API void ELZED_CALL_TYPE
	lzSetInvertArrayIndices( bool bInvertArrayIndices );

ELZED_API void ELZED_CALL_TYPE
	lzSetLastError( long lErrorID );

ELZED_API bool ELZED_CALL_TYPE
	lzSetNumArrayElement(	char cScope,
							const char* szVariableName,
							double dVariableValue,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzSetNumArrayElementByHandle(	LZObjectHandle hTheHandle,
									double dVariableValue,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API long ELZED_CALL_TYPE
	lzSetNumResult( LZObjectHandle hExOpUID, double dTheResult );

ELZED_API bool ELZED_CALL_TYPE
	lzSetNumVar(	char cScope,
					const char* szVariableName,
					double dVariableValue );

ELZED_API bool ELZED_CALL_TYPE
	lzSetNumVarByHandle(	LZObjectHandle hTheHandle,
							double dVariableValue );

ELZED_API void ELZED_CALL_TYPE
	lzSetOutputBase( char cOutputBaseCode );

ELZED_API void ELZED_CALL_TYPE
	lzSetQuoteMark( char cQuoteMarkCode );

ELZED_API void ELZED_CALL_TYPE
	lzSetRadixMark( char cRadixMarkCode );

ELZED_API bool ELZED_CALL_TYPE
	lzSetRealArrayElement(	char cScope,
							const char* szVariableName,
							double dRealValue,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzSetRealArrayElementByHandle(	LZObjectHandle hTheHandle,
									double dRealValue,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API long ELZED_CALL_TYPE
	lzSetRealResult( LZObjectHandle hExOpUID, double dTheResult );

ELZED_API bool ELZED_CALL_TYPE
	lzSetRealVar(	char cScope,
					const char* szVariableName,
					double dRealPart );

ELZED_API bool ELZED_CALL_TYPE
	lzSetRealVarByHandle(	LZObjectHandle hTheHandle,
							double dRealPart );

ELZED_API bool ELZED_CALL_TYPE
	lzSetStrArrayElement(	char cScope,
							const char* szVariableName,
							const char* szVariableValue,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API bool ELZED_CALL_TYPE
	lzSetStrArrayElementByHandle(	LZObjectHandle hTheHandle,
									const char* szVariableValue,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API long ELZED_CALL_TYPE
	lzSetStrResult( LZObjectHandle hExOpUID, const char* szTheResult );

ELZED_API bool ELZED_CALL_TYPE
	lzSetStrVar(	char cScope,
					const char* szVariableName,
					const char* szVariableValue );

ELZED_API bool ELZED_CALL_TYPE
	lzSetStrVarByHandle(	LZObjectHandle hTheHandle,
							const char* szVariableValue );
					
ELZED_API void ELZED_CALL_TYPE
	lzShowInfoBox( void );

ELZED_API double ELZED_CALL_TYPE
	lzVersion( void );

/////////////////////////////////////////////////////////////////
//  MacOSX Specific
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
//  Linux Specific
/////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////
//  Windows Specific
/////////////////////////////////////////////////////////////////

#ifdef WIN32

#ifndef _CRT_SECURE_NO_DEPRECATE
	#define _CRT_SECURE_NO_DEPRECATE 1
#endif

#include "windows.h"
#include "wtypes.h"
#include "oleauto.h"

ELZED_API BSTR ELZED_CALL_TYPE
	lzAnnotateExpB( const char* szExpression );

ELZED_API BSTR ELZED_CALL_TYPE
	lzAnnotateParsedExpB( LZObjectHandle hTheExpression );

ELZED_API BSTR ELZED_CALL_TYPE
	lzCheckExpB( const char* szExpression );

ELZED_API BSTR ELZED_CALL_TYPE
	lzEvalExpHndlToStrB( LZObjectHandle hTheExpression );

ELZED_API BSTR ELZED_CALL_TYPE
	lzEvalExpStrToStrB( const char* szExpression );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetContextNameB( LZObjectHandle hContextUID );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetCurrentContextNameB( void );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetErrorTextB( long lErrorID );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetLastErrorTextB( void );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetLastStrResultB( void );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetParmSigB( LZObjectHandle hExOpUID );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetStrArrayElementB(	char cScope,
							const char* szVariableName,
							long lDimensions,
							long lDim1,
							long lDim2,
							long lDim3,
							long lDim4,
							long lDim5,
							long lDim6 );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetStrArrayElementByHandleB(	LZObjectHandle hTheHandle,
									long lDimensions,
									long lDim1,
									long lDim2,
									long lDim3,
									long lDim4,
									long lDim5,
									long lDim6 );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetStrParmB( LZObjectHandle hExOpUID, long lParmIndex );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetStrVarValueB(	char cScope,
						const char* szVariableName );

ELZED_API BSTR ELZED_CALL_TYPE
	lzGetStrVarValueByHandleB( LZObjectHandle hTheHandle );

ELZED_API BSTR ELZED_CALL_TYPE
	lzRevertParsedExpB( LZObjectHandle hTheExpression );

#endif	// WIN32

/////////////////////////////////////////////////////////////////
//  Static Library
/////////////////////////////////////////////////////////////////

#ifndef ELZED_SHARED

ELZED_API bool ELZED_CALL_TYPE
	lzLoadElzed( void );

ELZED_API bool ELZED_CALL_TYPE
	lzUnloadElzed( void );

#endif	// ELZED_SHARED

#endif	// __LZElzedAPI__